jQuery(document).ready(function ($) {
    function fetchRecentPurchases() {
        $.ajax({
            url: EDD_Social_Proof_Ajax.ajax_url,
            type: 'POST',
            data: { action: 'get_recent_edd_purchases' },
            success: function (response) {
                if (response.length > 0) {
                    displayNotifications(response);
                }
            }
        });
    }

    function displayNotifications(purchases) {
        let delay = parseInt(EDD_Social_Proof_Ajax.notification_delay) * 1000;
        let displayTime = parseInt(EDD_Social_Proof_Ajax.display_time) * 1000;
        let bgColor = EDD_Social_Proof_Ajax.bg_color;
        let textColor = EDD_Social_Proof_Ajax.text_color;

        purchases.forEach((purchase, index) => {
            setTimeout(function () {
                let notification = $('<div class="edd-social-proof-notification">' +
                    '<span>' + purchase.name + ' just purchased ' + purchase.product + '!</span>' +
                    '</div>').css({
                        'background-color': bgColor,
                        'color': textColor
                    });

                $('body').append(notification);
                notification.fadeIn(500).delay(displayTime).fadeOut(500, function () { $(this).remove(); });
            }, index * (delay + displayTime));
        });
    }

    fetchRecentPurchases();
    setInterval(fetchRecentPurchases, 60000);
});